/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import tictim.paraglider.capabilities.Caps;
import tictim.paraglider.wind.WindChunk;

public class Wind
implements ICapabilityProvider {
    private final Long2ObjectMap<WindChunk> windChunks = new Long2ObjectOpenHashMap();
    private final LazyOptional<Wind> self = LazyOptional.of(() -> this);

    public void put(WindChunk windChunk) {
        this.windChunks.put(windChunk.getChunkPos().func_201841_a(), (Object)windChunk);
    }

    @Nullable
    public WindChunk get(int chunkX, int chunkZ) {
        return (WindChunk)this.windChunks.get(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk get(ChunkPos chunkPos) {
        return (WindChunk)this.windChunks.get(chunkPos.func_201841_a());
    }

    public WindChunk getOrCreate(int chunkX, int chunkZ) {
        WindChunk windChunk = this.get(chunkX, chunkZ);
        if (windChunk != null) {
            return windChunk;
        }
        windChunk = new WindChunk(new ChunkPos(chunkX, chunkZ));
        this.put(windChunk);
        return windChunk;
    }

    public WindChunk getOrCreate(ChunkPos chunkPos) {
        WindChunk windChunk = this.get(chunkPos);
        if (windChunk != null) {
            return windChunk;
        }
        windChunk = new WindChunk(chunkPos);
        this.put(windChunk);
        return windChunk;
    }

    @Nullable
    public WindChunk remove(int chunkX, int chunkZ) {
        return (WindChunk)this.windChunks.remove(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
    }

    @Nullable
    public WindChunk remove(ChunkPos chunkPos) {
        return (WindChunk)this.windChunks.remove(chunkPos.func_201841_a());
    }

    public Collection<WindChunk> getWindChunks() {
        return this.windChunks.values();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return cap == Caps.wind ? this.self.cast() : LazyOptional.empty();
    }

    @Nullable
    public static Wind of(ICapabilityProvider capabilityProvider) {
        return (Wind)capabilityProvider.getCapability(Caps.wind).orElse(null);
    }

    public static boolean isInside(World world, AxisAlignedBB boundingBox) {
        return Wind.isInside(world, MathHelper.func_76128_c((double)boundingBox.field_72340_a), MathHelper.func_76128_c((double)boundingBox.field_72338_b), MathHelper.func_76128_c((double)boundingBox.field_72339_c), MathHelper.func_76143_f((double)boundingBox.field_72336_d), MathHelper.func_76143_f((double)boundingBox.field_72337_e), MathHelper.func_76143_f((double)boundingBox.field_72334_f));
    }

    public static boolean isInside(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind == null) {
            return false;
        }
        int chunkXStart = minX >> 4;
        int chunkXEnd = maxX >> 4;
        int chunkZStart = minZ >> 4;
        int chunkZEnd = maxZ >> 4;
        for (int x = chunkXStart; x <= chunkXEnd; ++x) {
            for (int z = chunkZStart; z <= chunkZEnd; ++z) {
                WindChunk windChunk = wind.get(x, z);
                if (windChunk == null || !windChunk.isInsideWind(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                return true;
            }
        }
        return false;
    }
}

